import { StarXpandCommand } from "star-io10-web";

export class LabelSample13_For203dpiAnd300dpi_FoodProductLabel {
  static async createPrintCommands(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder().addPrinter(
        new StarXpandCommand.PrinterBuilder()
          .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
          .styleBold(true)
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleMagnification(
                new StarXpandCommand.MagnificationParameter(2, 2),
              )
              .actionPrintText("Star's Lunch Box -A-\n"),
          )
          .actionPrintText(
            "Use special sauce as you like\n" +
              "------------------------------------------------\n" +
              "MFG 2021/4/1\n" +
              "------------------------------------------------\n" +
              "Contains Wheat, Milk, and Soy.\n" +
              "May Contains Sesame.\n",
          )
          .actionCut(StarXpandCommand.Printer.CutType.Partial),
      ),
    );

    return await builder.getCommands();
  }
}
